<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager', false))
{
	exit;
}

/**
* Class to do data save/delete operations for tabs
*
* @package	postbit
*/
class vBDownloads_DataManager_File extends vB_DataManager
{
	/**
	* Array of recognised and required fields for tabs, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'fileid' 		=> array(TYPE_UINT, 	REQ_INCR, 	VF_METHOD, 	'verify_nonzero'),
		'userid' 		=> array(TYPE_UINT, 	REQ_YES, 	VF_METHOD),
		'filename' 		=> array(TYPE_STR, 		REQ_YES),
		'dateline' 		=> array(TYPE_UINT, 	REQ_AUTO),
		'filesize' 		=> array(TYPE_UINT, 	REQ_NO),
		'filetype' 		=> array(TYPE_STR, 		REQ_NO),
		'downloads' 	=> array(TYPE_UINT, 	REQ_NO),
		'image' 		=> array(TYPE_UINT, 	REQ_NO, 	VF_METHOD, 	'verify_offon'),
		'downloadid' 	=> array(TYPE_UINT, 	REQ_NO, 	VF_METHOD),
		'screenshot' 	=> array(TYPE_UINT, 	REQ_NO, 	VF_METHOD, 	'verify_offon'),
		'thumbnail' 	=> array(TYPE_UINT, 	REQ_NO, 	VF_METHOD, 	'verify_offon'),
		'hashkey' 		=> array(TYPE_STR, 		REQ_YES),
		'filepath' 		=> array(TYPE_STR, 		REQ_NO),
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	*
	* @var	array
	*/
	//var $bitfields = array('adminpermissions' => 'bf_ugp_adminpermissions');

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'dbtech_downloads_file';

	/**
	* Condition for update query
	*
	* @var	array
	*/
	var $condition_construct = array('fileid = \'%1$s\'', 'fileid');


	/**
	* Verifies that the downloadid is valid
	*
	* @param	integer	downloadid
	*
	* @return	boolean
	*/
	function verify_downloadid(&$downloadid)
	{
		// Validate offon
		return (!$downloadid OR count(VBDOWNLOADS::$db->fetchRow('SELECT downloadid FROM $dbtech_downloads_download WHERE downloadid = ?', array($downloadid))) == 1);
	}

	/**
	* Verifies that the offon flag is valid
	*
	* @param	string	Off/On flag
	*
	* @return	boolean
	*/
	function verify_offon(&$offon)
	{
		// Validate offon
		$offon = (!in_array($offon, array(0, 1)) ? 0 : $offon);
		
		return true;
	}

	/**
	* Verifies that the userid is valid
	*
	* @param	integer	userid
	*
	* @return	boolean
	*/
	function verify_userid(&$userid)
	{
		return $this->info['is_automated'] ? true : parent::verify_userid($userid);
	}

	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_filedata_presave')) ? eval($hook) : false;		

		if (($this->condition !== null AND $this->fetch_field('filesize') != $this->existing['filesize']) OR !$this->fetch_field('dateline'))
		{
			// Set dateline
			$timenow = TIMENOW;
			$this->do_set('dateline', $timenow);
		}

		$this->presave_called = $return_value;
		return $return_value;
	}
	
	/**
	* Additional data to update before a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function pre_delete($doquery = true)
	{
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_filedata_predelete')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_filedata_postsave')) ? eval($hook) : false;

		return true;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function post_delete($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_filedata_delete')) ? eval($hook) : false;

		if (substr($this->registry->options['dbtech_downloads_path_to_downloads'], 0, 2) == './')
		{
			// Prepare this
			$this->registry->options['dbtech_downloads_path_to_downloads'] = str_replace('./', DIR . '/', $this->registry->options['dbtech_downloads_path_to_downloads']);
		}

		if (!$this->existing['filepath'])
		{
			// Baleet the file if possible
			@unlink($this->registry->options['dbtech_downloads_path_to_downloads'] . '/' . $this->existing['fileid'] . '-' . $this->existing['filename']);
			@unlink($this->registry->options['dbtech_downloads_path_to_downloads'] . '/thumb-' . $this->existing['fileid'] . '-' . $this->existing['filename']);
		}
		
		return true;
	}
}